qui {

noi {
	/*************************************************/
	/*** Step 2.4.1. Motivating example 		    **/
	/*************************************************/
}

/* 2.4.0. Identify motivating examples in the data */
cd ..
cd ".\4. Master data"
clear all
use master_data
	
	* Motivating example 1: synthetic control estimates
	sum cntrycode if cntry == "Ukraine"
	local example = `r(mean)'
	sum year if independence_years == 0 & cntrycode == `example'
	local minyear = r(mean)-31
	local maxyear = r(mean)+19
	local min = r(mean)-11
	local max = r(mean)-1
	local min2 = r(mean)-16
	local max2 = r(mean)-6
	local indepyear = r(mean)
		
	* Identify example
	noi list cntry if independence_years == 0 & cntrycode == `example' & spring == 1
	
	/* 2.3.2. Collect data */
	
		* 2.3.2.1. Weights for synthetic version
		preserve
		cd ..
		cd ".\3. Intermediary results\3.1. Simulated gaps\3.1.1.1. Weights"
		use cntry_weights1_`example', clear
		rename _Co_Number cntrycode
		rename _W_Weight weight
		keep cntrycode weight
		save weights_`example', replace
		restore
		
		merge m:1 cntrycode using weights_`example'
		drop _merge
		erase weights_`example'.dta 
		
		gsort -weight
		preserve
		duplicates drop cntry, force
		keep cntry weight
		drop if weight == 0 | weight == .
		
		cd ..
		cd ..
		cd ..
		cd ".\5. TeX results"
		listtab ///
		using table3.tex,  replace ///
		rstyle(tabular) ///
		headlines("\begin{tabular}{lc} \\ \toprule \emph{Country} &	$~w^{*}$ \\ \midrule") ///
		footlines("\bottomrule \end{tabular}")
		
		noi di "Optimal weights for Synthetic Ukraine:"
		noi list cntry weight
		restore
		
		* 2.3.2.2. Predictor balance
		
			* Treated vs synthetic
			preserve
			cd ..
			cd ".\3. Intermediary results\3.1. Simulated gaps\3.1.1.2. Balance"
			cap use balance1_`example', clear
			gen cntrycode = `example'
			rename _rowname predictor
			gen year = 1939 + _n
			save balance, replace
			restore

			merge m:m cntrycode year using balance
			drop _merge
		
			* Compute pre-independence balance
			gen World = .
			local year = $startyear
			
			foreach var in  "baseline_gdpcap" "open"  "lpop" "market_potential" "bdeaths" "educ" "health" {
				
				* Compute average value for treated country
				sum `var' if year >= `min' & year <= `max'	& cntrycode == `example'
				replace Treated = r(mean) if year == `year' & cntrycode == `example'
				
				* Check the years with available observations, which were used in the synthetic control algorithm
				sum year if `var' != . & year >= `min' & year <= `max'	& cntrycode == `example'
				local Minyear = `r(min)'
				local Maxyear = `r(max)'
				
				* Compute the population-weighted  average growth predictor in the rest of the world, over all independent countries
				sum `var' if independence_years>-1 & year >= `Minyear' & year <= `Maxyear'	[w=pop]
				replace World = r(mean) if year == `year' & cntrycode == `example'
				
				* Compute average values of the growth predictor in the synthetic country, using the weights assigned by the SCM
				sum `var' if independence_years>-1 & year >= `Minyear' & year <= `Maxyear'		[w=weight]
				replace Synth = r(mean) if year == `year' & cntrycode == `example'
				local year = `year' + 1
				}
			
			foreach var in  "Treated" "World"  "Synth" {
				replace `var' = round(`var',.001) if predictor != "bdeaths(1981/1990)"
				replace `var' = round(`var'*1000,.001) if predictor == "bdeaths(1981/1990)"
				replace `var' = round(`var'/1000000,.001) if predictor == "market_potential(1981/1990)"
				}
			
			preserve
			keep predictor Treated Synthetic World
			keep if predictor != ""
			replace predictor = "Per capita GDP" if predictor == "baseline_gdpcap(1981(1)1990)"
			replace predictor = "Trade openness" if predictor == "open(1989/1990)"
			replace predictor = "log Population" if predictor == "lpop(1981/1990)"
			replace predictor = "Battle deaths (per 1000 heads)" if predictor == "bdeaths(1981/1990)"
			replace predictor = "Market potential (millions)" if predictor == "market_potential(1981/1990)"
			replace predictor = "Educational attainment" if predictor == "educ(1981/1990)"
			replace predictor = "Life expectancy" if predictor == "health(1981/1990)"
			gen estimation_window = ""
			replace estimation_window = "1981-1990" if predictor == "Per capita GDP"
			replace estimation_window = "1989-1990" if predictor == "Trade openness"
			replace estimation_window = "1981-1990" if predictor == "log Population"
			replace estimation_window = "1981-1990" if predictor == "Battle deaths (per 1000 heads)"
			replace estimation_window = "1981-1990" if predictor == "Market potential (millions)"
			replace estimation_window = "1981-1990" if predictor == "Educational attainment"
			replace estimation_window = "1981-1990" if predictor == "Life expectancy"
			gen order = 1
			replace order = 2 if predictor == "log Population"
			replace order = 3 if predictor == "Educational attainment"
			replace order = 4 if predictor == "Life expectancy"
			replace order = 5 if predictor == "Trade openness"
			replace order = 6 if predictor == "Market potential (millions)"
			replace order = 7 if predictor == "Battle deaths (per 1000 heads)"
			sort order
			drop order
			
			cd ..
			cd ..
			cd ..
			cd ".\5. TeX results"
			listtab predictor estimation_window Treated Synthetic World ///
			using table4.tex,  replace ///
			rstyle(tabular) ///
			headlines("\begin{tabular}{lcccc} \\ \toprule \emph{Predictor} & \emph{Estimation window} &	\emph{Ukraine} & \emph{Synthetic Ukraine} & \emph{World} \\ \midrule ") ///
			footlines("\bottomrule \end{tabular}")
			
			noi di "Predictor balance before secession:"
			noi list predictor estimation_window Treated Synth World
			restore
			
		* 2.3.2.3. Per capita GDP trajectories
			
			* Generate variable that will collect synthetic per capita GDP trajectory
			gen synth_gdpcap = .
			label var synth_gdpcap "Counterfactual per capita GDP (in absence of state fragmentation)"
			
			* Use weights to compute this counterfactual trajectory
			gen weighted_gdpcap = weight * baseline_gdpcap			// Use these to compute weighted average (synthetic) per capita GDP trajectory
			sum year if cntrycode == `example' & independence_years == 0 & year >= $startyear
			local yoi = r(mean)
			sum weighted_gdpcap if year == `yoi' & weighted_gdpcap != 0
			local componentparts = r(N)
			foreach year of numlist $startyear / 2016 {
				sum weighted_gdpcap if year == `year' & weighted_gdpcap != 0 
				replace synth_gdpcap = r(sum) if cntrycode == `example' & year == `year' & `r(sum)' != 0 & `r(N)' == `componentparts' // Simulated trajectory equal to weighted average trajectories of other countries where the weights were defined in the algorithm
				}
				
			* Compute logarithmic counterfactual trajectory
			gen synth_lgdpcap = ln(synth_gdpcap)
			sum synth_lgdpcap
			local ceiling = 1.01*`r(max)'
				
			* Plot the results
			sum year if synth_lgdpcap != . & cntrycode == `example'
			sort cntrycode year
			twoway 	(scatteri `ceiling' `max' `ceiling' `min', bcolor(gs12) recast(area)) || ///
					(line baseline_lgdpcap year if year >= `minyear' & year <= `maxyear' & cntrycode == `example', lcolor(gs0)) || ///
					(line synth_lgdpcap year if year >= `minyear' & year <= `maxyear' & cntrycode == `example', lcolor(gs0) lpattern(dash)) || ///	
					,ytitle("log per capita GDP", size(large)) xtitle(Year, size(large)) legend(order(2 "Actual with secession" 3 "Synthetic without secession")) xline(`indepyear', lcolor(red) lpattern(shortdash)) graphregion(color(white)) bgcolor(white)
			graph export figure3_a.pdf, replace
			
		* 2.3.2.4. Discrepancy: independence dividend estimates
		
			gen discrepancy = baseline_lgdpcap - synth_lgdpcap
			
			twoway line discrepancy independence_years if independence_years >= -30 & independence_years <= 20 & cntrycode == `example' & discrepancy != ., lcolor(gs0) ytitle("Gap in log per capita GDP", size(large)) xtitle("Years of independence", size(large)) xline(0, lcolor(red) lpattern(shortdash)) yline(0, lcolor(gs5) lpattern(shortdash))  graphregion(color(white)) bgcolor(white)
			graph export figure3_b.pdf, replace
			
			noi sum discrepancy if independence_years == 20
			
		* 2.3.2.5. Root Mean Squared Prediction Error (RMSPE)

			local SPE = 0
			local total_observations = 0
						
			foreach year of numlist -10/-1 {
				sum discrepancy if cntrycode == `example' & independence_years == `year'
				if r(mean) != . {
					local SPE = `SPE' + (r(mean)^2)
					local total_observations = `total_observations' + 1
					}
				}
			local MSPE = `SPE'/`total_observations'
			local RMSPE = round(sqrt(`MSPE'),.001)
			
			noi di "RMSPE: `RMSPE'"
			
		* 2.3.2.6. Pre-independence period

			* first post-independence year

				* Get estimated Ukrainian gap in first post-independence year
				sum discrepancy if cntrycode == `example' & independence_years == 1
				scalar impact_1 = round(r(mean),.001)
			
				*T-test
				ttest discrepancy == `r(mean)' if cntrycode == `example' & independence_years < 0 & independence_years > -11
				scalar pvalue_1 = round(r(p_u),.001)
				
				noi di "Estimated gap Ukraine: first pre-independence year",_continue
				noi di impact_1,_continue
				noi di "[pvalue =",_continue
				noi di pvalue_1,_continue
				noi di  "]"
				noi di ""
				
		* 2.3.2.7. Accounting for anticipation effects
			
			* Reload data
			cd ..
			cd ".\4. Master data"
			use master_data, clear
			
			* Weights for synthetic version (estimation window = t-15 - t-5)
			preserve
			cd ..
			cd ".\3. Intermediary results\3.1. Simulated gaps\3.1.1.1. Weights"
			use cntry_weights2_`example', clear
			rename _Co_Number cntrycode
			rename _W_Weight weight
			keep cntrycode weight
			save weights_`example', replace
			restore
			
			merge m:1 cntrycode using weights_`example'
			drop _merge
			erase weights_`example'.dta 
			
			* Generate variable that will collect synthetic per capita GDP trajectory
			gen synth_gdpcap = .
			label var synth_gdpcap "Counterfactual per capita GDP (in absence of state fragmentation)"
			
			* Use weights to compute this counterfactual trajectory
			gen weighted_gdpcap = weight * baseline_gdpcap			// Use these to compute weighted average (synthetic) per capita GDP trajectory
			sum year if cntrycode == `example' & independence_years == 0 & year >= $startyear
			local yoi = r(mean)
			sum weighted_gdpcap if year == `yoi' & weighted_gdpcap != 0
			local componentparts = r(N)
			foreach year of numlist $startyear / 2016 {
				sum weighted_gdpcap if year == `year' & weighted_gdpcap != 0 
				replace synth_gdpcap = r(sum) if cntrycode == `example' & year == `year' & `r(sum)' != 0 & `r(N)' == `componentparts' // Simulated trajectory equal to weighted average trajectories of other countries where the weights were defined in the algorithm
				}
				
			* Compute logarithmic counterfactual trajectory
			gen synth_lgdpcap = ln(synth_gdpcap)
			sum synth_lgdpcap
			local ceiling = 1.01*`r(max)'
				
			* Plot the results
			cd ..
			cd ..
			cd ..
			cd ".\5. TeX results"
			sum year if synth_lgdpcap != . & cntrycode == `example'
			sort cntrycode year
			twoway 	(scatteri `ceiling' `max2' `ceiling' `min2', bcolor(gs12) recast(area)) || ///
					(line baseline_lgdpcap year if year >= `minyear' & year <= `maxyear' & cntrycode == `example', lcolor(gs0)) || ///
					(line synth_lgdpcap year if year >= `minyear' & year <= `maxyear' & cntrycode == `example', lcolor(gs0) lpattern(dash)) || ///	
					,ytitle("log per capita GDP", size(large)) xtitle(Year, size(large)) legend(order(2 "Actual with secession" 3 "Synthetic without secession")) xline(`indepyear', lcolor(red) lpattern(shortdash)) graphregion(color(white)) bgcolor(white)
			graph export figureA1_a.pdf, replace
			
		* 2.3.2.4. Discrepancy: independence dividend estimates
		
			gen discrepancy = baseline_lgdpcap - synth_lgdpcap
			
			twoway line discrepancy independence_years if independence_years >= -30 & independence_years <= 20 & cntrycode == `example' & discrepancy != ., lcolor(gs0) ytitle("Gap in log per capita GDP", size(large)) xtitle("Years of independence", size(large)) xline(0, lcolor(red) lpattern(shortdash)) yline(0, lcolor(gs5) lpattern(shortdash))  graphregion(color(white)) bgcolor(white)
			graph export figureA1_b.pdf, replace
			
			noi sum discrepancy if independence_years == 20
								
	* Reroute to directory containing dofiles
	cd ..
	cd ".\1. Dofiles"
	}
